//■共通関数
var i;

//■緯度経度変換（10進数→60進数）
function chg10to60(num, NEWS) {   //緯度の場合：NEWS=NS, 経度の場合：NEWS＝EW
		if (NEWS == "NS") {
			(num > 0) ? NEWS == "N" : NEWS == "S";
		} else {
			(num > 0) ? NEWS == "E" : NEWS == "W";
		}
	return chgDMStoD(num) + NEWS;
}

	function chgDMStoD(num) {	
		num = Math.abs(num);
		dd = Math.floor(num);
		mm = Math.floor((num -dd) * 60);
		ss = ((num-dd) * 60 -mm) * 60 ;

		return  ""+ dd + (""+(mm+100)).substr(1) + (""+(ss+100)).substr(1,5) ;
	}

//■緯度経度変換（60進数→10進数）
function chg60to10(str) {
	//緯度か経度かを判定する
	if (str.match(/N$|S$/)){	//N,Sで終わる場合、緯度と判定する。
		ddLen=2;				//緯度の場合、度は2桁。
	}else{						//それ以外は経度と判定する。
		ddLen=3;				//経度の場合、度は3桁。
	}

	//緯度の場合最初の2桁、経度の場合最初の3桁の「度」を取り出す
	dd = str.substr(0,ddLen)-0; 
	//緯度：3桁、経度：4桁以上の場合、「分」を取り出す。
	mm = 0;
	if (str.length > (ddLen + 1)) { mm = (str.substr(ddLen, 2) - 0) / 60; }  
	//緯度：5桁、経度：6桁以上の場合、「秒」を取り出す。
	ss = 0;
	if (str.length > (ddLen+3)) {ss= (str.substring(ddLen+2,str.length-1)-0) / 3600 ;}  
	
	//南緯、西経をマイナス表記する
	if (str.match(/W$|S$/)){
		return (dd + mm + ss) * -1;
	}else{
		return (dd + mm + ss) ;
	};
} 


//■テキストから不要な文字列を消去して、60進数の緯度経度のカンマ区切りに整形する 
//元のテキスト999999N9999999E or 北緯99°99′99.99" 東経999°99′99.99"　⇒　緯度,経度,緯度,経度・・・
//前提条件：緯度経度の順に並んでいること。
	
function transformPsn(str) {
	var LatLng = [];
	str = ZKtoHK(str);	        			// 全角→半角
	str = str.toUpperCase();				// 大文字に変換
	str = str.replace(/[^0-9NEWS.東西南北]/g,"");	// 不要な文字列(数字とNEWS.以外)を消去
	str = str.replace(/[北]/g,"N");	        // 北をNに置き換え
	str = str.replace(/[東]/g,"E");	        // 東をEに置き換え
	str = str.replace(/[西]/g,"W");	        // 西をWに置き換え
	str = str.replace(/[南]/g,"S");	        // 南をSに置き換え

	ary = str.split(/((?:N)|(?:E)|(?:W)|(?:S))/)  //NEWSのどれかで区切る
	if (ary[0] == "") { ary.splice(0, 1) } //最初の配列が空白の場合、要素を削除する
	for (i = 0; i < ary.length - 1; i = i + 4) {
		if (/[NEWS]/.test(ary[0])) {
			LatLng[i / 4] = { lat60: ary[i + 1] + ary[i], lng60: ary[i + 3] + ary[i + 2] };
		} else {
			LatLng[i / 4] = { lat60: ary[i] + ary[i + 1], lng60: ary[i + 2] + ary[i + 3] };
		}
		LatLng[i / 4].lat = chg60to10(LatLng[i / 4].lat60);
		LatLng[i / 4].lng = chg60to10(LatLng[i / 4].lng60);
	};
	return LatLng;
}

//■全角→半角に変換
function ZKtoHK(str) {
	return str.replace(/[Ａ-Ｚａ-ｚ０-９．]/g, function (s) {
		return String.fromCharCode(s.charCodeAt(0) - 0xFEE0);
	});
};
