﻿//【初期動作】

function init(){
//■ベースマップを表示      
	var map = L.map('base_map',{zoomControl:false, preferCanvas:true});
	map.setView([35.40, 136], 5);
	L.control.scale({position: 'bottomright'}).addTo(map);
	L.control.zoom().addTo(map);
	//白地図
	var gsiblank = L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/blank/{z}/{x}/{y}.png',
        {attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>"});
	//地理院地図の標準地図タイル
	var gsistd =L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/std/{z}/{x}/{y}.png', 
        {attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>"});
	//地理院地図の淡色地図タイル
	var gsipale = L.tileLayer('http://cyberjapandata.gsi.go.jp/xyz/pale/{z}/{x}/{y}.png',
        {attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>"});
	//地理院地図のEnglishタイル
	var gsieng = L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/english/{z}/{x}/{y}.png',
        {attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>"});
	//地理院地図の写真タイル
	var gsiPhoto = L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/seamlessphoto/{z}/{x}/{y}.jpg',
        {attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>"});
	//オープンストリートマップ
	//var osm = L.tileLayer('http://tile.openstreetmap.jp/{z}/{x}/{y}.png',
      //{attribution: "<a href='http://osm.org/copyright' target='_blank'>OpenStreetMap</a> contributors" });

	//baseMapsオブジェクトのプロパティに各タイルを設定
	var baseMap = {
        "白地図" : gsiblank,
        "地理院地図" : gsistd,
        "淡色地図" : gsipale,
        "地理院地図English" : gsieng,
        "写真" : gsiPhoto, 
	};
		
	//オーバーレイレイヤー:人口密集地タイルを定義
	var did2010 = L.tileLayer('http://cyberjapandata.gsi.go.jp/xyz/did2010/{z}/{x}/{y}.png',{
	attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>",
	});
	did2010.setOpacity(0.3);
	var overlayLayer = {
		"人口密集地":did2010,
	}
	
	//レイヤーコントロールを追加：引数1ベースマップ、引数2オーバーレイレイヤー
	var layerControl = L.control.layers(baseMap,overlayLayer,{"collapsed":true,});
	layerControl.addTo(map);
	gsiblank.addTo(map);
		
//■プラグイン
	//▼距離方位プラグイン
	L.control.ruler().addTo(map);
 
	//▼マウス位置を左下に表示するプラグイン
	L.control.mousePosition().addTo(map);

//■設定	  
	//アイコンの設定   	
	var Icon1 = L.divIcon({className: 'iconOrange', iconAnchor: [4, 4] });
	var Icon2 = L.divIcon({className: 'iconRed', iconAnchor: [3, 3] });
	
	//レイヤーグループの設定	
    var layerGroup = L.layerGroup();  
    const MunisFeature = L.featureGroup();
 
    
//■クリック位置の取得
	map.on('click', function(e) {
		showlatlng(e);
		showClickPt(map);
	});
	

//■住所を表示（オープンストリートマップのAPIを利用）
	$(function() {
  		$("#Button9").click(function(){
			$("#adrs").text("---");
    		$.get("https://nominatim.openstreetmap.org/reverse?format=json&lat=" + 
    		$("#clat").text() + "&lon=" + $("#clon").text() + "&zoom=18&addressdetails=1") 
    		.done(function(data){$("#adrs").text(data.display_name) });
    	});
	})

//■２地点間の距離と方位（地理院地図のスクリプトを利用）    
	$("#Button50").on('click', function () { 
		var LatLng = transformPsn($("#CalcPsn").val());
		var pt1 = { lat: LatLng[0].lat, lng: LatLng[0].lng };
		var pt2 = { lat: LatLng[1].lat, lng: LatLng[1].lng };
		OUT1 = GsiUtilsDistanceCalculator(pt1, pt2);
		OUT2 = GsiUtilsDistanceCalculator(pt2, pt1);
		$("#CalcPsnOut").text("測地線長(m)：" + OUT1.s + 
							"　方位角：" + OUT2.alp21 * (180 / 3.14159265358979) + 
							"　方位角(逆)：" + OUT1.alp21 * (180 / 3.14159265358979));
	})
        
//■距離と高度を変換
	$("#num,#conv").on('change', function () {
    	 $("#convResult").text($("#num").val() * $("#conv").val());
	})
 
//■ポイント、ライン、ポリゴン、円【共通function】
	//▼ポイントをマップに表示
	function addPointToView(latlngs){ 
		Object.keys(latlngs).forEach(function (i) {
			Points = L.marker([latlngs[i].lat, latlngs[i].lng], { icon: Icon2, title: latlngs[i].lat60 + " " + latlngs[i].lng60 });
			layerGroup.addLayer(Points);
		})
		layerGroup.addTo(map);
	};  
	//▼ラインをマップに表示    
	function addPolyineToView(Pts) {
		var latlngs = Pts.map((obj) => [obj.lat, obj.lng]);
		var label = Pts.map((obj) => obj.lat60 + obj.lng60);
		polyline = L.polyline(latlngs, {color:'red', weight: 2});
		polyline.bindTooltip(label.toString());
		layerGroup.addLayer(polyline);
		layerGroup.addTo(map);
		if ($("#zoom:checked").val() == "on") {map.fitBounds(polyline.getBounds())};
	}
	
	//▼ポリゴンをマップに表示    
	function addPolygonToView(Pts){
		 var latlngs = Pts.map((obj) => [obj.lat, obj.lng]);
		var label = Pts.map((obj) => obj.lat60 + obj.lng60);
		polygon = L.polygon(latlngs, {color:'red', weight: 2, fill: false});
		polygon.bindTooltip(label.toString());
		layerGroup.addLayer(polygon);
		layerGroup.addTo(map);
		if ($("#zoom:checked").val() == "on") {map.fitBounds(polyline.getBounds())};
	} 
	
	//▼円をマップに表示
	function addCircleToView(Pts,Rad){
		var latlngs = Pts.map((obj) => [obj.lat, obj.lng]);
		var label = Pts.map((obj) => obj.lat60 + obj.lng60);
		polyCir = L.circle(latlngs[0], {radius:Rad, color: 'red', weight: 2, fill: false });
		polyCir.bindTooltip(label.toString() +" " + Rad/1000+"km");
		layerGroup.addLayer(polyCir);
		layerGroup.addTo(map);
		if ($("#zoom:checked").val() == "on") {map.fitBounds(polyCir.getBounds())};
	}


//■ポイント
	$("#Button10").on('click', function () { 
		addPointToView(transformPsn($("#Psn").val()));
	});
 
//■ライン
	$("#Button11").on('click', function () {
		addPolyineToView(transformPsn($("#Psn").val()));
	});

//■ポリゴン
	$("#Button12").on('click', function () {
		addPolygonToView(transformPsn($("#Psn").val()));
	});

//■円
	$("#Button20").on('click', function () {
		addCircleToView(transformPsn($("#Cir1").val()),$("#Cir2").val()*1852);
	});

	$("#Button21").on('click', function () { 
		addPointToView(transformPsn($("#Cir1").val()));
	});

//■ポイントを囲む円
	$("#Button13").on('click', function () { 
		out = findCenterPt($("#Psn").val());
		$("#Cir1").val(out[0].lat60 + out[0].lng60);
		$("#Cir2").val(out.rad);
		addCircleToView(out,out.rad*1852);
	});

//■楕円（ポリゴン）
    $("#Button30").on('click', function () {
		var cPT =  $("#Elp1").val(); //中心点
		var Rad1 = $("#Elp2").val()-0; //長径(NM)
		var Rad2 = $("#Elp3").val()-0; //短径(NM)
		var Deg  = $("#Elp4").val()-0; //角度(deg)

		var latlngs = getEllipse(cPT,Rad1,Rad2,Deg);
		var label = $("#Elp1").val() + " " + Rad1 +"NM "+ Rad2 +"NM " + Deg + "deg"
		polygon = L.polygon(latlngs, {color:'red', weight: 2, fill: false});
		polygon.bindTooltip(label.toString());
		layerGroup.addLayer(polygon);
		layerGroup.addTo(map);
	});

	$("#Button31").on('click', function () { 
		addPointToView(transformPsn($("#Elp1").val()));
	});


//■レイヤーの削除           
    $("#Button14").on('click', function () {
		if (map && layerGroup) {
			map.removeLayer(layerGroup);
			layerGroup = L.layerGroup();
		}
	});


//■ARP
    $("#ARP").change(function() {addARPtoView(map,Icon1)});

//■竹島・尖閣諸島
    $("#TKSN").change(function () { addTKSNtoView(map,Icon2) });

//■外国AP
    $("#OvsAP").change(function () { addOvsAPtoView(map,Icon1) });

//■FIR
    $("#FIR").change(function(){addFIRtoView(map)});

//■ADIZ
    $("#ADIZ").change(function(){ addADIZtoView(map)});

//■OLS 制限表面
	$("#OLS").change(function(){addOLStoView(map)});
	addOLStoView(map);   //初期表示させる

//■CTZ 管制圏・情報圏
    $("#CTZ").change(function (){addCTZtoView(map)});
    addCTZtoView(map);   //初期表示させる

//■空域制限byNOTAM
    $("#RSTDbyNOTAM").change(function(){addRSTDbyNOTAMtoView(map)});

//■市区町村
    $("#MUNIS").change(function(){addMUNIStoView(map)});
    
    //■市区町村のClear
	$("#Button40").on('click', function () {MunisClear()});	
	
    //■市区町村のノータム用テキストのセット
	$("#Button41").on('click', function () {creatTextArea2()});	
    
//■空域制限・制限空域
    $("#RSTD").change(function(){addRSTDtoView(map)});
    
//■民間訓練試験空域
    $("#CivilTRNG").change(function(){addCivilTRNGtoView(map)});

//■自衛隊訓練試験空域
    $("#JsdfTRNG").change(function(){addJsdfTRNGtoView(map)});    

//■超音速飛行空域
	$("#Supersonic").change(function(){ addSupersonictoView(map)});   

//■回廊
	$("#Corridor").change(function(){addCorridortoView(map)});   

//■ポイントとポリゴンの重なりをチェックする     
    $("#Button_AreaCK").on('click', function(){checkInclusion(map)});


}
  