var lat1, lat2, lon1, lon2
var d, crs12, crs21
	
//**************CD********************************
//Compute true course and distance between points.
//**************CD********************************

function ComputeFormCD(lat1,lat2,lon1,lon2){
	
//緯度経度をラジアンに変換する 
glat1=(Math.PI/180)*lat1
glat2=(Math.PI/180)*lat2
glon1=(Math.PI/180)*lon1
glon2=(Math.PI/180)*lon2

a = 6378.137  			//GRS80長半径
f = 1 / 298.257223563   //GRS80扁平率

var r, tu1, tu2, cu1, su1, cu2, s1, b1, f1
var x, sx, cx, sy, cy,y, sa, c2a, cz, e, c, d
var EPS= 0.00000000005
var faz, baz, s
var iter=1
var MAXITER=100
  if ((glat1+glat2==0.) && (Math.abs(glon1-glon2)==Math.PI)){
    alert("Course and distance between antipodal points is undefined")
    glat1=glat1+0.00001 // allow algorithm to complete
    }
  if (glat1==glat2 && (glon1==glon2 || Math.abs(Math.abs(glon1-glon2)-2*Math.PI) <  EPS)){
    alert("Points 1 and 2 are identical- course undefined")
    out=new MakeArray(0)
    out.d=0
    out.crs12=0
    out.crs21=Math.PI
    return out
  }
  r = 1 - f
  tu1 = r * Math.tan (glat1)
  tu2 = r * Math.tan (glat2)
  cu1 = 1. / Math.sqrt (1. + tu1 * tu1)
  su1 = cu1 * tu1
  cu2 = 1. / Math.sqrt (1. + tu2 * tu2)
  s1 = cu1 * cu2
  b1 = s1 * tu2
  f1 = b1 * tu1
  x = glon2 - glon1
  d = x + 1 // force one pass
  while ((Math.abs(d - x) > EPS) && (iter < MAXITER))
    {
      iter=iter+1
      sx = Math.sin (x)
//       alert("sx="+sx)
      cx = Math.cos (x)
      tu1 = cu2 * sx
      tu2 = b1 - su1 * cu2 * cx
      sy = Math.sqrt(tu1 * tu1 + tu2 * tu2)
      cy = s1 * cx + f1
      y = atan2 (sy, cy)
      sa = s1 * sx / sy
      c2a = 1 - sa * sa
      cz = f1 + f1
      if (c2a > 0.)
	cz = cy - cz / c2a
      e = cz * cz * 2. - 1.
      c = ((-3. * c2a + 4.) * f + 4.) * c2a * f / 16.
      d = x
      x = ((e * cy * c + cz) * sy * c + y) * sa
      x = (1. - c) * x * f + glon2 - glon1
    }
  faz = modcrs(atan2(tu1, tu2))
  baz = modcrs(atan2(cu1 * sx, b1 * cx - su1 * cu2) + Math.PI)

  x = Math.sqrt ((1 / (r * r) - 1) * c2a + 1)
  x +=1
  x = (x - 2.) / x
  c = 1. - x
  c = (x * x / 4. + 1.) / c
  d = (0.375 * x * x - 1.) * x
  x = e * cy
  s = ((((sy*sy*4.-3.)*(1.-e-e)*cz*d/6.-x)*d/4.+cz)*sy*d+y)*c*a*r
  	  
  out=new MakeArray(0)
  out.d=s/1.852                   //NMに変換
  out.crs12=faz*(180/Math.PI)
  out.crs21=baz*(180/Math.PI)

  if (Math.abs(iter-MAXITER)<EPS){
    alert("Algorithm did not converge")
  }
  return out
 
}


//**************Dir********************************************
//Compute lat/lon given radial and distance from a known point
//**************Dir********************************************

function ComputeFormDir(lat1,lon1,d12,crs12){

var a,invf

glat1=(Math.PI/180)*lat1
glon1=(Math.PI/180)*lon1
s=d12*1.852
faz=crs12*Math.PI/180  // radians
//alert("lat1="+lat1+" lon1="+lon1+" d12="+d12+" crs12="+crs12)
 
// glat1 initial geodetic latitude in radians N positive 
// glon1 initial geodetic longitude in radians E positive 
// faz forward azimuth in radians
// s distance in units of a (=nm)
 
var EPS= 0.00000000005
var r, tu, sf, cf, b, cu, su, sa, c2a, x, c, d, y, sy, cy, cz, e
var glat2,glon2,baz,f
 
  if ((Math.abs(Math.cos(glat1))<EPS) && !(Math.abs(Math.sin(faz))<EPS)){
    alert("Only N-S courses are meaningful, starting at a pole!")
  }
 
	a = 6378.137           //GRS80長半径
	f = 1 / 298.257223563  //GRS80扁平率
  r = 1 - f
  tu = r * Math.tan (glat1)
  sf = Math.sin (faz)
  cf = Math.cos (faz)
  if (cf==0){
     b=0.
  }else{
     b=2. * atan2 (tu, cf)
  }
  cu = 1. / Math.sqrt (1 + tu * tu)
  su = tu * cu
  sa = cu * sf
  c2a = 1 - sa * sa
  x = 1. + Math.sqrt (1. + c2a * (1. / (r * r) - 1.))
  x = (x - 2.) / x
  c = 1. - x
  c = (x * x / 4. + 1.) / c
  d = (0.375 * x * x - 1.) * x
  tu = s / (r * a * c)
  y = tu
  c = y + 1
  while (Math.abs (y - c) > EPS)
    {
      sy = Math.sin (y)
      cy = Math.cos (y)
      cz = Math.cos (b + y)
      e = 2. * cz * cz - 1.
      c = y
      x = e * cy
      y = e + e - 1.
      y = (((sy * sy * 4. - 3.) * y * cz * d / 6. + x) *
              d / 4. - cz) * sy * d + tu
    }
 
  b = cu * cy * cf - su * sy
  c = r * Math.sqrt (sa * sa + b * b)
  d = su * cy + cu * sy * cf
  glat2 = modlat(atan2 (d, c))
  c = cu * cy - su * sy * cf
  x = atan2 (sy * sf, c)
  c = ((-3. * c2a + 4.) * f + 4.) * c2a * f / 16.
  d = ((e * cy * c + cz) * sy * c + y) * sa
  glon2 = modlon(glon1 + x - (1. - c) * d * f)	// fix date line problems 
  baz = modcrs(atan2 (sa, b) + Math.PI)
 
  out=new MakeArray(0)
  out.lat=glat2*(180/Math.PI)
  out.lon=glon2*(180/Math.PI)
  out.crs21=baz*(180/Math.PI)

  return out
}



//***************Utility****************************************

function MakeArray(n){
   this.length=n
   for (var i=1;i<=n;i++){
     this[i]=0
   }
   return this
}



function atan2(y,x){
var out
  if (x <0)            { out= Math.atan(y/x)+Math.PI}
  if ((x >0) && (y>=0)){ out= Math.atan(y/x)}
  if ((x >0) && (y<0)) { out= Math.atan(y/x)+2*Math.PI}
  if ((x==0) && (y>0)) { out= Math.PI/2}
  if ((x==0) && (y<0)) { out= 3*Math.PI/2}  
  if ((x==0) && (y==0)) {
    alert("atan2(0,0) undefined")
    out= 0.
  }  
  return out
}
 
function mod(x,y){
  return x-y*Math.floor(x/y)
}
 
function modlon(x){
  return mod(x+Math.PI,2*Math.PI)-Math.PI
}
 
function modcrs(x){
  return mod(x,2*Math.PI)
}
 
function modlat(x){
  return mod(x+Math.PI/2,2*Math.PI)-Math.PI/2
}
