

//●ポップアップの設定
	function PopupPoint(feature){
	 return '<pre>' + JSON.stringify(feature.properties, null, ' ')
	 .replace(/[\{\}"]|\\n|bgcolor/g, '') + '</pre>'};
	
//■ARP
    function addARPtoView(map,Icon1) {
        if ($("#ARP:checked").val() == "on") {
            ptsARP = L.geoJSON(ARP, {
                pointToLayer: function (feature, latlng) {
                    return L.marker(latlng, {icon:Icon1, title: PopupPoint(feature)});
                }
            }).addTo(map);
        } else {
            map.removeLayer(ptsARP);
            ptsARP = null;
        }
    };

//■竹島・尖閣諸島
    function addTKSNtoView(map,Icon2) {
        if ($("#TKSN:checked").val() == "on") {
            ptsTKSN = L.geoJSON(TKSN, {
                pointToLayer: function (feature, latlng) {
                    return L.marker(latlng, {icon:Icon2, title: PopupPoint(feature)});
                }
            }).addTo(map);
        } else {
            map.removeLayer(ptsTKSN);
            ptsTKSN = null;
        }
    };

//■外国AP
    function addOvsAPtoView(map,Icon1) {
        if ($("#OvsAP:checked").val() == "on") {
            ptsOvsAP = L.geoJSON(OvsAP, {
                pointToLayer: function (feature, latlng) {
                    return L.marker(latlng, {icon:Icon1, title: PopupPoint(feature)});
                }
            }).addTo(map);
        } else {
            map.removeLayer(ptsOvsAP);
            ptsOvsAP = null;
        }
    };

	
//●スタイルの設定
	var polyBlue   = {"color": 'Blue',   "weight": 1,  "fill":false};
	var polyTeal   = {"color": 'Teal',   "weight": 1,  "fill":false};
	var polyBrown  = {color: 'Brown',  weight: 1,  fill:false};
	var polyOrange = {"color": 'Orange', "weight": 1,  "fill":false};
	var polyGray   = {"color": 'Gray',   "weight": 1,  "fillopacity": 0.01};
	var polyGreen  = {"color": 'Green',  "weight": 1,  "fillopacity": 0.01};
	var polyOrchid = {"color": 'Orchid', "weight": 1,  "fillopacity": 0.01};
	var polyViolet = {"color": 'Violet', "weight": 1,  "fillopacity": 0.01};
	var polyTomato = {"color": 'Tomato', "weight": 0.1,"fillopacity": 0.01};
	var polyDgreen = {"color": 'Darkgreen', "weight": 0.1,"fillOpacity": 0.1};
	
	
//●ポップアップとクリックの両方を可能にする
	var PopupClick = function (feature, layer) {
                    	//layer.bindPopup(feature.properties.Name);
                    	layer.on('click', function (e) {
            				this.openPopup();
							showlatlng(e);
							showClickPt(this._map);
        				});
                	}
                	

//■FIR        			
	function addFIRtoView(map) {
		if ($("#FIR:checked").val() == "on") {
			polyFIR = L.geoJson(FIR, {
				style: polyBlue
			}).addTo(map);
		} else {
			map.removeLayer(polyFIR);
			polyFIR = null;
		};
	};

//■ADIZ        			
	function addADIZtoView(map) {
		if ($("#ADIZ:checked").val() == "on") {
			polyADIZ = L.geoJson(ADIZ, {
				style: polyTeal
			}).addTo(map);
		} else {
			map.removeLayer(polyADIZ);
			polyADIZ = null;
		};
	};
	
//■OLS 制限表面        			
	function addOLStoView(map) {
		if ($("#OLS:checked").val() == "on") {
			polyOLS = L.geoJson(OLS, {
				style: polyOrange,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyOLS);
			polyOLS = null;
		};
	};

//■CTZ 管制圏・情報圏        			
	function addCTZtoView(map) {
		if ($("#CTZ:checked").val() == "on") {
			polyCTZ = L.geoJson(CTZ, {
				style: polyBrown,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyCTZ);
			polyCTZ = null;
		};
	};

//■空域制限・制限空域 (ByNOTAM)       			
	function addRSTDbyNOTAMtoView(map) {
		if ($("#RSTDbyNOTAM:checked").val() == "on") {
			polyRSTDbyNOTAM = L.geoJson(RSTDbyNOTAM, {
				style: polyOrchid,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyRSTDbyNOTAM)
			polyRSTDbyNOTAM = null
		};
	};

//■市区町村 
	//レイヤーグループの設定	
    const MunisFeature = L.featureGroup();	      			

	function addMUNIStoView(map) {
		if ($("#MUNIS:checked").val() == "on") {
			MunisFeature.clearLayers();
			MunisFeature.addLayer(L.geoJson(MUNIS, {
			 	style: polyDgreen
			}));
			 MunisFeature.addTo(map);
		} else {
			map.removeLayer(MunisFeature)
			MunisFeature = null
		};
	};

//■市区町村の選択＆色塗り
	let MunisAry = []; 
	MunisFeature.on('click', function (e) {
		if (e.layer.feature.properties.N03_007 === undefined) { return };
		
		let eMuni = e.layer.feature.properties.N03_007;
		let ePref = e.layer.feature.properties.N03_001;
		let eGun = e.layer.feature.properties.N03_003;
		let eShi = e.layer.feature.properties.N03_004;
		let eKu = e.layer.feature.properties.N03_005;		
		let eShiGunEn = e.layer.feature.properties.ShiGun;
		let ePrefEn = e.layer.feature.properties.Pref;		

		if (e.layer.options.fillOpacity == 0.1) {
			e.layer.setStyle({
				fillOpacity : 0.3
			}); 

			MunisAry.push({ mCode: eMuni, mPref: ePref, mGun: eGun, mShi: eShi, mKu:eKu,mShiGunEn: eShiGunEn, mPrefEn:" IN " + ePrefEn })
			MunisAry.sort((a, b) => a.mCode - b.mCode); //並べ替え
			
			$("#MunisTxt1").val(creatTextArea1(MunisAry));
			
		} else {
			e.layer.setStyle({
				fillOpacity: 0.1,
			});
			
			//重複する場合、MunisAryオブジェクトから選択した市区町村を削除する
			let MunisAryIndex = MunisAry.findIndex(obj => obj.MunisCode === selectedMuni);
			if (MunisAryIndex != -1) {
				MunisAry.splice(MunisAryIndex, 1); 
			}
			$("#MunisTxt1").val(creatTextArea1(MunisAry));
		}
	});
	
	//
	function sortMunis(MunisAry) {
		MunisAry.sort(function(a, b) {return a.mCode > b.mCode})
	}
	
	//選択した市区町村（配列）を表示用テキストに整形
	function creatTextArea1(MunisAry) { 
		var result = Object.values(MunisAry)
			.map(item => `${item.mCode} ${item.mPref} ${item.mGun} ${item.mShi} ${item.mKu}`)
			.join("\n");
		result = result.replace(/ null/g, ''); //nullを削除
		return result;
    }

	//選択した市区町村（配列）を表示用テキストに整形（ノータム記載用）
	function creatTextArea2() { 
		for(let i = 0; i < MunisAry.length; i++) {
			for(let j = i+1; j < MunisAry.length; j++) {
				if (MunisAry[i].mPrefEn == MunisAry[j].mPrefEn){ //県が同じだったら、県を削除
						MunisAry[i].mPrefEn = " null";
					if (MunisAry[i].mShiGunEn == MunisAry[j].mShiGunEn){ //市郡が同じだったら、市郡を削除
						MunisAry[i].mShiGunEn = "dupe";
					} 
				}
			}
		}
		var result = Object.values(MunisAry)
			.map(item => `${item.mShiGunEn}${item.mPrefEn}`)
			.join(", ");
		result = result.replace(/ null/g, ''); //nullを削除
		result = result.replace(/dupe, /g, ''); //nullを削除
		result = result.replace(/ ,/g, ''); //INの前のカンマを削除		
		$("#MunisTxt2").val(result);
    }
    
	//市区町村をクリア
	function MunisClear() {
		MunisAry = [];
		$("#MunisTxt1").val('');
		$("#MunisTxt2").val('');
		MunisFeature.eachLayer(function (layer) {
			layer.setStyle({
				fillOpacity: 0.1
			});
		});
    }
    
 
//■空域制限・制限空域        			
	function addRSTDtoView(map) {
		if ($("#RSTD:checked").val() == "on") {
			polyRSTD = L.geoJson(RSTD, {
				style: polyViolet,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyRSTD)
			polyRSTD = null
		};
	};

//■民間訓練試験空域        			
	function addCivilTRNGtoView(map) {
		if ($("#CivilTRNG:checked").val() == "on") {
			polyCivilTRNG = L.geoJson(CivilTRNG, {
				style: polyGreen,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyCivilTRNG)
			polyCivilTRNG = null
		};
	};

//■自衛隊訓練試験空域        			
	function addJsdfTRNGtoView(map) {
		if ($("#JsdfTRNG:checked").val() == "on") {
			polyJsdfTRNG = L.geoJson(JsdfTRNG, {
				style: polyGray,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyJsdfTRNG)
			polyJsdfTRNG = null
		};
	};

//■超音速飛行空域        			
	function addSupersonictoView(map) {
		if ($("#Supersonic:checked").val() == "on") {
			polySupersonic = L.geoJson(Supersonic, {
				style: polyGray,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polySupersonic)
			polySupersonic = null
		};
	};

//■回廊        			
	function addCorridortoView(map) {
		if ($("#Corridor:checked").val() == "on") {
			polyCorridor = L.geoJson(Corridor, {
				style: polyGray,
				onEachFeature: PopupClick
			}).addTo(map);
		} else {
			map.removeLayer(polyCorridor)
			polyCorridor = null
		};
	};


