//■ポイントとポリゴンの重なりをチェックする 
function checkInclusion(map) {   
 
  		$("#AreaCK").text('');

		var pt = L.marker([$("#clat").text() , $("#clon").text()]);
		var aryARP = [];
  		map.eachLayer(function(layer) {
    		if(layer instanceof L.Polygon) {   //
    			if (layer.getBounds().contains(pt.getLatLng())) {  //ポリゴンを囲む矩形に含まれる場合
    				if(isMarkerInsidePolygon(pt, layer)){          //ポリゴンがポイントを含む場合
						
						//ポイントの標高を取得
    					var ptElev = $("#elev").text()-0;     
    					if (isNaN(ptElev)){ptElev = 0};

						//ARPの緯度経度と標高を取得
    					var aryARP = getARPLatLngElev(layer);  
    					var str = layer.feature.properties.Name;  //ポリゴンの名前を取得
    					
    					//制限高を取得
    					if (str.includes('進入')){  
    						var result = mathApchSfc(pt,layer,ptElev);
    					}else if (str.includes('転移')){
    						var result = mathTransitionSfc(pt,layer,ptElev);
    					}else if (str.includes('水平')&&!str.includes('外側')){
    						var ObjH = Math.round((aryARP.elev + 45 - ptElev)* 100) / 100;
    						var result = '　ARP標高：' + aryARP.elev + 'm,制限高：45m,最大物件高：' + ObjH + 'm';
    					}else if (str.includes('円錐')){
    						var result = mathConicalSfc(pt,layer,aryARP,ptElev);
    					}else if (str.includes('外側水平')){
    						var ObjH = Math.round((aryARP.elev + 295 - ptElev)* 100) / 100;
    						var result = '　ARP標高：' + aryARP.elev + 'm,制限高：295m,最大物件高：' + ObjH + 'm';
    					}else{
    						var result = ""
    					}
    					$("#AreaCK").html($("#AreaCK").html() + layer.feature.properties.Name + result + '<br>');
    					
    				}
  				}
    		}; 
  		});
}

	
//■contains()とraytracing algorithmで内外判定
	function isMarkerInsidePolygon(pt, poly) {
  		var x = pt.getLatLng().lat, y = pt.getLatLng().lng;
  		var polyPoints = poly.getLatLngs()[0][0];
  		if (!Array.isArray(polyPoints)) {polyPoints = poly.getLatLngs()[0]};
		var inside = false;
		
        for (var i = 0, j = polyPoints.length - 1; i < polyPoints.length; j = i++) {
			var xi = polyPoints[i].lat, yi = polyPoints[i].lng;
			var xj = polyPoints[j].lat, yj = polyPoints[j].lng;
			var intersect = ((yi > y) !== (yj > y)) && (x < ((xj - xi) * (y - yi) / (yj - yi) + xi));
			if (intersect) {inside = !inside};
         }
         return inside;
    }
                
 //■ARPの緯度経度と標高を取得
 	function getARPLatLngElev(layer) {
 		//ARPの緯度経度を取得
		var ARPdata = ARP.features;  //ARP.geojsonファイルより
		var Target =[];
		for (i = 0; i < ARPdata.length -1; i++){
			var ARPlatlng = new L.LatLng(ARPdata[i].properties.Lat, ARPdata[i].properties.Lon);
			if (layer.getBounds().contains(ARPlatlng)) {
				 Target.lat = ARPdata[i].properties.Lat;
				 Target.lon = ARPdata[i].properties.Lon;
				 Target.elev =  ARPdata[i].properties.Elev;
			}
		}
		return Target;
  	}


//■進入表面の計算
function mathApchSfc(pt, poly,ptElev){
    
    	var latP = pt.getLatLng().lat, lngP = pt.getLatLng().lng;
  		var polyPt = poly.getLatLngs()[0][0];
  			if (!Array.isArray(polyPt)) {polyPt = poly.getLatLngs()[0]};
        
        //進入表面ポリゴンのうち、着陸帯に接する点を探す         
        polyPt.sort(function(a,b){return(a['alt'] - b['alt']);}); //altでソート
        var lat1 = polyPt[0].lat, lng1 = polyPt[0].lng;
		var lat2 = polyPt[1].lat, lng2 = polyPt[1].lng;
		if (lat1 == lat2 && lng1 == lng2){      //1点目と2点目が同じ場合、2点目を削除 ←不要かな？
			polyPt.splice(1, 1); 
			var lat2 = polyPt[1].lat, lng2 = polyPt[1].lng;
    	};
    	
    	//着陸帯に接する2点の距離と方位を計算
    	out0 = GsiDistCalc(lat1,lat2,lng1,lng2);   //距離：d,方位：crs12,逆方位：crs21 
        
        //着陸帯に接する1点からptへの距離と方位を計算 
		out1 = GsiDistCalc(lat1,latP,lng1,lngP);   //距離：d,方位：crs12,逆方位：crs21
		
		//角度θ(theta)を計算
    	th =  Math.min(Math.abs(out0.crs12 + 90 - out1.crs12),Math.abs(out0.crs21 + 90 - out1.crs12))
    	
		//直角三角形の公式で距離を求める
		var dist = Math.abs((out1.d * Math.cos(th * (Math.PI / 180)))) ;  //着陸帯からの距離
		var RwyElev = (polyPt[0].alt + polyPt[1].alt ) / 2;
		var olsHgt =  dist * 1/50; //制限高（勾配1/50);
		var objHgt = RwyElev + olsHgt - ptElev;
    
    return '　着陸帯標高：' + Math.round(RwyElev*10)/10 + 'm,距離：' + Math.round(dist*10)/10 + 'm, 制限高：' + 
    		Math.round(olsHgt*10)/10 + 'm,最大物件高：' + Math.round(objHgt*10)/10 + 'm';
};
    
 //■転移表面の計算  
function mathTransitionSfc(pt,poly,ptElev){
    
    	var latP = pt.getLatLng().lat, lngP = pt.getLatLng().lng;
  		var polyPt = poly.getLatLngs()[0][0];
  			if (!Array.isArray(polyPt)) {polyPt = poly.getLatLngs()[0]};
    
        //転移表面ポリゴンのうち、着陸帯に接する点を探す         
        sortpolyPt = polyPt.slice().sort(function(a,b){return(a['alt'] - b['alt']);}); //altでソート（非破壊的ソート）
        var lat1 = sortpolyPt[0].lat, lng1 = sortpolyPt[0].lng;
		var lat2 = sortpolyPt[1].lat, lng2 = sortpolyPt[1].lng;
		
		//着陸帯に接する2点の距離と方位を計算
    	out0 = GsiDistCalc(lat1,lat2,lng1,lng2);   //距離：d,方位：crs12,逆方位：crs21 
        
        //着陸帯に接する2点とptの距離と方位を計算 
		out1 = GsiDistCalc(lat1,latP,lng1,lngP);   //距離：d,方位：crs12,逆方位：crs21
		out2 = GsiDistCalc(lat2,latP,lng2,lngP);   //距離：d,方位：crs12,逆方位：crs21
		
		//角度θ(theta)を計算
    	th =  Math.min(Math.abs(out0.crs12 - out1.crs12),Math.abs(out0.crs21 - out1.crs12)) ;
    	
    	//着陸帯からの距離を計算
		var dist = (out1.d * Math.cos(th * (Math.PI / 180)))  ;
			
		if (out0.d > out1.d && out0.d > out2.d){ //着陸帯の横の場合
			var RwyElev = (sortpolyPt[0].alt + sortpolyPt[1].alt ) / 2;
			var olsHgt =  dist * 1/7; 
			var objHgt = RwyElev + olsHgt - ptElev;

			return '　着陸帯標高：' + Math.round(RwyElev*10)/10 + 'm,距離：' + 
					Math.round(dist*10)/10 + 'm, 制限高：' + 
					Math.round(olsHgt*10)/10 + 'm,最大物件高：' + Math.round(objHgt*10)/10 + 'm';
		
		}else{ //進入表面の横の場合
			
			//着陸帯に接する2点のうち、ptに近いほうをptA、遠いほうをptBとする
			if(out1.d < out2.d){
				ptA =  sortpolyPt[0];
				ptB =  sortpolyPt[1];
			}else{
				ptA =  sortpolyPt[1];
				ptB =  sortpolyPt[0];
			}
			
			//ptCを探す
			var idxA = polyPt.findIndex((({lat}) => lat == ptA.lat) && (({lng}) => lng == ptA.lng)); 
			var idxB = polyPt.findIndex((({lat}) => lat == ptB.lat) && (({lng}) => lng == ptB.lng));
			if (idxA > idxB){
				idxC = idxA + 1;
			}else{
				idxC = idxA - 1;
			}
			if (idxC = -1){idxC = polyPt.length - 1};
			if (idxC = polyPt.length){idxC = 0};
			ptC = polyPt[idxC];

			
			//ptA-ptを含む三角形の計算
			
			out1 = GsiDistCalc(ptA.lat,latP,ptA.lng,lngP);   //距離：d,方位：crs12,逆方位：crs21
    		th1 =  Math.min(Math.abs(out0.crs12 - out1.crs12),Math.abs(out0.crs21 - out1.crs12)) ;
			dist1 = (out1.d * Math.cos(th1 * (Math.PI / 180)))  ;
			dist2 = (out1.d * Math.sin(th1 * (Math.PI / 180)))  ;
			RwyElev = (sortpolyPt[0].alt + sortpolyPt[1].alt ) / 2
			olsHgt1 = RwyElev + dist1 * 1/50;
			
			//ptA-ptCを含む三角形の計算
			
			out2 = GsiDistCalc(ptA.lat,ptC.lat,ptA.lng,ptC.lng);   //距離：d,方位：crs12,逆方位：crs21
    		th2 =  Math.min(Math.abs(out0.crs12 - out2.crs12),Math.abs(out0.crs21 - out2.crs12)) ;		
			
			dist3 = (dist1 * Math.tan(th2 * (Math.PI / 180)))  ;
			dist4 = dist2 - dist3;
			olsHgt2 = dist4 * 1/7;
			olsHgt3 = olsHgt1 + olsHgt2;
			objHgt = RwyElev + olsHgt3 - ptElev;

			return '　着陸帯標高：' + Math.round(RwyElev*10)/10 + 'm,距離：' + 
					Math.round(dist1*10)/10 + 'm(1/50)+' + Math.round(dist4*10)/10 +'m(1/7), 制限高：' + 
					Math.round(olsHgt1*10)/10 + 'm+' + Math.round(olsHgt2*10)/10 + 'm=' + 
					Math.round(olsHgt3*10)/10 + 'm,最大物件高：' + Math.round(objHgt*10)/10 + 'm';
		};
};


//■円錐表面の計算  
function mathConicalSfc(pt,poly,aryARP,ptElev){
		var latP = pt.getLatLng().lat, lngP = pt.getLatLng().lng;
		out = GsiDistCalc(aryARP.lat,latP,aryARP.lon,lngP);   //距離：d,方位：crs12,逆方位：crs21
		dist1 = Math.round(out.d *10)/10;
		dist2 = Math.round(dist1 - 3000 *10)/10;
		olsHgt = Math.round((dist2 * 1/50 + 45)*10)/10; 
		objHgt = Math.round((aryARP.elev + olsHgt - ptElev)*10)/10 
		
		return '　ARP標高：' + aryARP.elev + 'm,距離：3000m+' + 
				Math.round(dist2*10)/10 + 'm(1/50), 制限高：' + 
				Math.round(olsHgt*10)/10 + 'm,最大物件高：'+ Math.round(objHgt*10)/10 + 'm';
}	

//■距離と方位の計算
function GsiDistCalc(lat1,lat2,lng1,lng2){ 
  		var pt1 = {lat: lat1, lng: lng1 };
        var pt2 = {lat: lat2, lng: lng2 };
        OUT1 = GsiUtilsDistanceCalculator(pt1, pt2);
        OUT2 = GsiUtilsDistanceCalculator(pt2, pt1);
        var result = {d: OUT1.s, crs12: OUT2.alp21 * (180 / 3.14159265358979), crs21: OUT1.alp21 * (180 / 3.14159265358979)};
        return result;
}

//■緯度経度等を表示
function showlatlng(e) {
     	var lat = e.latlng.lat.toFixed(6);
    	var lon = e.latlng.lng.toFixed(6);
    	$("#clat").text(lat);
    	$("#clon").text(lon);
    	$("#latlon60").text(chg10to60(lat,"N") + " " + chg10to60(lon,"E"));
    	getElev(lat,lon);
    	$("#adrs").text("---");   
}

	var layerClickPt = L.layerGroup();
	var Icon3 = L.divIcon({className: 'iconRed', iconAnchor: [3, 3] });
		
//■クリック位置にアイコンを表示
function showClickPt(map){  
		if (layerClickPt) {layerClickPt.clearLayers()};
    	var ClickPt = L.marker([$("#clat").text() , $("#clon").text()],
    		{icon:Icon3, title: $("#latlon60").text()});
    		layerClickPt.addLayer(ClickPt);
    		layerClickPt.addTo(map);
} 
	
//■標高を表示（国土地理院のAPIを利用）
function getElev(lat,lon){
  		const url = "https://cyberjapandata2.gsi.go.jp/general/dem/scripts/getelevation.php?lon=" + 
 					lon + "&lat=" + lat + "&outtype=JSON" ;
		fetch(url)
		.then( response => response.json() )
		.then( data  => {if(data != null){$("#elev").text(data.elevation)}});
}


